/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.forgespi.language.IModInfo;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.NotNull;
import org.magmafoundation.magma.common.MagmaConstants;
import org.magmafoundation.magma.configuration.MagmaConfig;

public class ModsCommand
extends BukkitCommand {
    public ModsCommand(@NotNull String name) {
        super(name);
        this.description = "Gets a list of mods running on the server";
        this.usageMessage = "/mods";
        this.setPermission("magma.command.mods");
        this.setAliases(Arrays.asList("modlist"));
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        sender.sendMessage("Mods " + this.getModList());
        return true;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        return Collections.emptyList();
    }

    @NotNull
    private String getModList() {
        StringBuilder modList = new StringBuilder();
        List mods = MagmaConstants.modInfoList;
        for (IModInfo mod : mods) {
            if (modList.length() > 0) {
                modList.append((Object)ChatColor.WHITE);
                modList.append(", ");
            }
            modList.append(ChatColor.GREEN + mod.getDisplayName());
            if (!MagmaConfig.instance.modCommandPrintIDs.getValues().booleanValue()) continue;
            modList.append(ChatColor.WHITE + " (" + mod.getModId() + " v." + mod.getVersion() + ")");
        }
        return "(" + mods.size() + "): " + modList.toString();
    }
}

